/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.LongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.LongRunningTask;
import com.mojang.realmsclient.gui.McoWorldTemplateScreen;
import com.mojang.realmsclient.gui.ScreenWithCallback;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsEditBox;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class CreateOnlineWorldScreen
extends ScreenWithCallback<WorldTemplate> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final long worldId;
    private RealmsScreen lastScreen;
    private RealmsEditBox nameBox;
    private String name;
    private static int CREATE_BUTTON = 0;
    private static int CANCEL_BUTTON = 1;
    private static int WORLD_TEMPLATE_BUTTON = 2;
    private boolean error;
    private String errorMessage = "You must enter a name!";
    private WorldTemplate selectedWorldTemplate;
    private RealmsButton templateButton;

    public CreateOnlineWorldScreen(long worldId, RealmsScreen lastScreen) {
        this.worldId = worldId;
        this.lastScreen = lastScreen;
    }

    public void tick() {
        this.nameBox.tick();
        this.name = this.nameBox.getValue();
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.buttonsAdd(CreateOnlineWorldScreen.newButton((int)CREATE_BUTTON, (int)(this.width() / 2 - 100), (int)(this.height() / 4 + 120 + 17), (int)97, (int)20, (String)CreateOnlineWorldScreen.getLocalizedString((String)"mco.create.world")));
        this.buttonsAdd(CreateOnlineWorldScreen.newButton((int)CANCEL_BUTTON, (int)(this.width() / 2 + 5), (int)(this.height() / 4 + 120 + 17), (int)95, (int)20, (String)CreateOnlineWorldScreen.getLocalizedString((String)"gui.cancel")));
        this.nameBox = this.newEditBox(this.width() / 2 - 100, 65, 200, 20);
        this.nameBox.setFocus(true);
        if (this.name != null) {
            this.nameBox.setValue(this.name);
        }
        if (this.selectedWorldTemplate == null) {
            this.templateButton = CreateOnlineWorldScreen.newButton((int)WORLD_TEMPLATE_BUTTON, (int)(this.width() / 2 - 100), (int)107, (int)200, (int)20, (String)CreateOnlineWorldScreen.getLocalizedString((String)"mco.template.default.name"));
            this.buttonsAdd(this.templateButton);
        } else {
            this.templateButton = CreateOnlineWorldScreen.newButton((int)WORLD_TEMPLATE_BUTTON, (int)(this.width() / 2 - 100), (int)107, (int)200, (int)20, (String)(CreateOnlineWorldScreen.getLocalizedString((String)"mco.template.name") + ": " + this.selectedWorldTemplate.name));
            this.buttonsAdd(this.templateButton);
        }
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == CANCEL_BUTTON) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        } else if (button.id() == CREATE_BUTTON) {
            this.createWorld();
        } else if (button.id() == WORLD_TEMPLATE_BUTTON) {
            Realms.setScreen((RealmsScreen)new McoWorldTemplateScreen(this, this.selectedWorldTemplate, false));
        }
    }

    public void keyPressed(char ch, int eventKey) {
        this.nameBox.keyPressed(ch, eventKey);
        if (eventKey == 15) {
            this.nameBox.setFocus(!this.nameBox.isFocused());
        }
        if (eventKey == 28 || eventKey == 156) {
            this.buttonClicked(this.templateButton);
        }
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    private void createWorld() {
        if (this.valid()) {
            WorldCreationTask worldCreationTask = new WorldCreationTask(this.worldId, this.nameBox.getValue(), this.selectedWorldTemplate);
            LongRunningMcoTaskScreen longRunningMcoTaskScreen = new LongRunningMcoTaskScreen(this.lastScreen, worldCreationTask);
            longRunningMcoTaskScreen.start();
            Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
        }
    }

    private boolean valid() {
        this.error = this.nameBox.getValue() == null || this.nameBox.getValue().trim().equals("");
        return !this.error;
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
        this.nameBox.mouseClicked(x, y, buttonNum);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(CreateOnlineWorldScreen.getLocalizedString((String)"mco.selectServer.create"), this.width() / 2, 11, 0xFFFFFF);
        this.drawString(CreateOnlineWorldScreen.getLocalizedString((String)"mco.configure.world.name"), this.width() / 2 - 100, 52, 0xA0A0A0);
        if (this.error) {
            this.drawCenteredString(this.errorMessage, this.width() / 2, 167, 0xFF0000);
        }
        this.nameBox.render();
        super.render(xm, ym, a);
    }

    @Override
    public void callback(WorldTemplate worldTemplate) {
        this.selectedWorldTemplate = worldTemplate;
    }

    class WorldCreationTask
    extends LongRunningTask {
        private final String name;
        private final WorldTemplate selectedWorldTemplate;
        private final long worldId;

        public WorldCreationTask(long worldId, String name, WorldTemplate selectedWorldTemplate) {
            this.worldId = worldId;
            this.name = name;
            this.selectedWorldTemplate = selectedWorldTemplate;
        }

        @Override
        public void run() {
            String title = RealmsScreen.getLocalizedString((String)"mco.create.world.wait");
            this.setTitle(title);
            RealmsClient client = RealmsClient.createRealmsClient();
            try {
                if (this.selectedWorldTemplate != null) {
                    client.initializeWorld(this.worldId, this.name, this.selectedWorldTemplate.id);
                } else {
                    client.initializeWorld(this.worldId, this.name, "-1");
                }
                Realms.setScreen((RealmsScreen)CreateOnlineWorldScreen.this.lastScreen);
            }
            catch (RealmsServiceException e) {
                LOGGER.error("Couldn't create world");
                this.error(e.toString());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Couldn't create world");
                this.error(e.getLocalizedMessage());
            }
            catch (IOException e) {
                LOGGER.error("Could not parse response creating world");
                this.error(e.getLocalizedMessage());
            }
            catch (Exception e) {
                LOGGER.error("Could not create world");
                this.error(e.getLocalizedMessage());
            }
        }
    }
}

